//
//  TSPLCompressionVC.m
//  PrinterDemo
//
//  Created by Apple Mac mini intel on 2024/5/30.
//

#import "TSPLCompressionVC.h"
#import "UIView+Toast.h"
#import "XSDKPrinter.h"
@interface TSPLCompressionVC ()<UIImagePickerControllerDelegate,UINavigationControllerDelegate>
@property (weak, nonatomic) IBOutlet UISegmentedControl *modeSeg;
@property (weak, nonatomic) IBOutlet UITextField *widthTextField;
@property (weak, nonatomic) IBOutlet UITextField *heightTextField;
@property (weak, nonatomic) IBOutlet UILabel *picStatusLabel;
@property (strong, nonatomic) UIImage *compressionImg;
@end

@implementation TSPLCompressionVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"TSPL Compression";
    self.compressionImg = [UIImage imageNamed:@"image"];
    // Do any additional setup after loading the view.
}

- (IBAction)selectPicAction:(id)sender {
    UIImagePickerController * imagePicker = [[UIImagePickerController alloc] init];
    imagePicker.editing = YES;
    imagePicker.delegate = self;
    imagePicker.allowsEditing = YES;
    imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    [self presentViewController:imagePicker animated:YES completion:nil];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info {
    
    [picker dismissViewControllerAnimated:YES completion:nil];
    UIImage *img = [info valueForKey:UIImagePickerControllerOriginalImage];
    
    if(CGImageGetWidth(img.CGImage) > 480) {
        img = [self imageWithscaleImage:img andScaleWidth:480 andScaleHeight:480*CGImageGetHeight(img.CGImage)/CGImageGetWidth(img.CGImage)];
    }
    
    if(img) {
        self.compressionImg = img;
        self.picStatusLabel.text = @"Ready";
        self.picStatusLabel.textColor = [UIColor greenColor];
    } else {
        self.compressionImg = [UIImage imageNamed:@"nv_test"];
        self.picStatusLabel.text = @"Default";
        self.picStatusLabel.textColor = [UIColor blackColor];
    }
}

-(UIImage *)imageWithscaleImage:(UIImage *)image andScaleWidth:(CGFloat)maxWidth andScaleHeight:(CGFloat)maxHeight {
    CGFloat width = image.size.width;
    CGFloat height = image.size.height;
    if (maxHeight == 0) {
        maxHeight = (int)(maxWidth * height / width);
    }
    
    if (maxWidth == 0) {
        maxWidth = (int)(maxHeight * width / height);
    }
    
    CGSize size = CGSizeMake(maxWidth, maxHeight);
    UIGraphicsBeginImageContext(size);
    [image drawInRect:CGRectMake(0, 0, maxWidth, maxHeight)];
    UIImage *resultImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return resultImage;
}

- (IBAction)printAction:(id)sender {
    
    if([self.widthTextField.text intValue] < 20 || [self.widthTextField.text intValue] > 220) {
        [self.view makeToast:@"Valid width value(20-220)" duration:2.f position:CSToastPositionBottom];
        return;
    }
    
    if([self.heightTextField.text intValue] < 20) {
        [self.view makeToast:@"Valid height value(>20)" duration:2.f position:CSToastPositionBottom];
    }
    
    // test pic print
    UIImage *img = self.compressionImg;

    XTSPLCommand *command = [[XTSPLCommand alloc] init];
    [command sizeMm:[self.widthTextField.text intValue] height:[self.heightTextField.text intValue]];
    [command gapMm:2 n:0];
    [command cls];
   
    if (self.modeSeg.selectedSegmentIndex == 0) {
        [command bitmapAtX:0 y:0 mode:BMPModeOverwrite image:img];
    } else {
        [command zlibBitmapAtX:0 y:0 mode:BMPModeOverwriteZlib image:img];
    }
    
    [command print];
    
    [[XBLEManager sharedInstance] writeCommandWithData:[command getCommand] writeCallBack:^(CBCharacteristic *characteristic, NSError *error) {
        if (error) {
            NSLog(@"error:%@", error);
        } else {
            NSLog(@"write succes");
        }
    }];
    
}


@end
